/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware;

import emulator.EmulatorException;
import emulator.hardware.CPUEventHandler;
import emulator.hardware.CPUExecutionObserver;
import emulator.hardware.HwNumber;
import emulator.support.CpuState;
import java.io.PrintStream;
import java.util.Observer;

public interface CPU {
    public void reset() throws EmulatorException;

    public void irq() throws EmulatorException;

    public void nmi() throws EmulatorException;

    public void step() throws EmulatorException;

    public void stepOver() throws EmulatorException;

    public void go() throws EmulatorException;

    public void halt();

    public void waitForHalt();

    public void addRunningStateObserver(Observer var1);

    public void printState(PrintStream var1) throws EmulatorException;

    public void setEventHandler(CPUEventHandler var1);

    public void setExecutionObserver(CPUExecutionObserver var1);

    public void breakAt(HwNumber var1, boolean var2);

    public void stopOnceAt(HwNumber var1);

    public void clearAllStops();

    public void enableBreakOnReturn(boolean var1);

    public void setValue(String var1, int var2);

    public int getPC();

    public long getTicks();

    public CpuState getCpuState();
}

